// GlobalConfigurationDlg.cpp : implementation file
//

#include "stdafx.h"
#include "mushclient.h"
#include "GlobalConfigurationDlg.h"

#ifdef _DEBUG
//#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CGlobalConfigurationDlg dialog


CGlobalConfigurationDlg::CGlobalConfigurationDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CGlobalConfigurationDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CGlobalConfigurationDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}


void CGlobalConfigurationDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CGlobalConfigurationDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CGlobalConfigurationDlg, CDialog)
	//{{AFX_MSG_MAP(CGlobalConfigurationDlg)
	ON_BN_CLICKED(IDC_BROWSE, OnBrowse)
	ON_BN_CLICKED(IDC_NEW, OnNew)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CGlobalConfigurationDlg message handlers

void CGlobalConfigurationDlg::OnBrowse() 
{
  CFileDialog filedlg (TRUE,   // loading the file
                       "xml",    // default extension
                       App.m_GlobalConfigurationFileName,  // suggested name
                       OFN_HIDEREADONLY | OFN_FILEMUSTEXIST,
                       "All files (*.*)|*.*|"
                       "XML files (*.xml)|*.xml|"
                       "|",    // filter 
                       this);  // parent window

  filedlg.m_ofn.lpstrTitle = "Global configuration";

  if (filedlg.DoModal () != IDOK)
    return;    // cancelled dialog
	
  App.m_GlobalConfigurationFileName = filedlg.GetPathName ();

  App.WriteProfileString ("Miscellaneous", "GlobalConfigurationFileName", App.m_GlobalConfigurationFileName);

  OnOK ();

}

void CGlobalConfigurationDlg::OnNew() 
{
	  CFileDialog	filedlg (FALSE,						// FALSE for FileSave
					  "xml",						// default extension
					  App.m_GlobalConfigurationFileName,						// initial file name
					  OFN_HIDEREADONLY|OFN_OVERWRITEPROMPT|OFN_PATHMUSTEXIST,
                       "All files (*.*)|*.*|"
                       "XML files (*.xml)|*.xml|"
                       "|",    // filter 
					  this);

	  filedlg.m_ofn.lpstrTitle = "Global configuration";

	  if (filedlg.DoModal() != IDOK)
		  return;

  App.m_GlobalConfigurationFileName = filedlg.GetPathName ();

  // remember file name
  App.WriteProfileString ("Miscellaneous", "GlobalConfigurationFileName", App.m_GlobalConfigurationFileName);

  // get original prefs
  App.GetGlobalPrefsFromRegistry ();

  // write config file
  App.WriteGlobalPrefs ();

  OnOK ();
  
}
