-- table of outstanding threads that are waiting
wait_table = {}

-- called by a timer to resume a thread
function wait_timer_resume (name)
  thread = wait_table [name]
  if thread then
    assert (coroutine.resume (thread))
  end -- if
end -- function wait_timer_resume 

-- called by a trigger to resume a thread
function wait_trigger_resume (name, line, wildcards)
  EnableTrigger (name, false)  -- don't want it to fire again
  DoAfterSpecial (1, "DeleteTrigger ('" .. name .. "')", 12) -- delete it
  thread = wait_table [name]
  if thread then
    assert (coroutine.resume (thread, line, wildcards))
  end -- if
end -- function wait_trigger_resume 

-- we call this to wait in a script
function wait (thread, seconds)
  id = "wait_timer_" .. GetUniqueNumber ()
  hours = math.floor (seconds / 3600)
  seconds = seconds - (hours * 3600)
  minutes = math.floor (seconds / 60)
  seconds = seconds - (minutes * 60)
  status = AddTimer (id, hours, minutes, seconds, "",
            timer_flag.Enabled + timer_flag.OneShot + 
            timer_flag.Temporary + timer_flag.Replace, 
            "wait_timer_resume")
  assert (status == error_code.eOK, error_desc [status])
  wait_table [id] = thread
  coroutine.yield ()
end -- function wait

-- we call this to wait for a trigger with a regexp
function waitforregexp (thread, regexp)
  id = "wait_trigger_" .. GetUniqueNumber ()
  status = AddTrigger (id, regexp, "",
            trigger_flag.Enabled + trigger_flag.RegularExpression + 
            trigger_flag.Temporary + trigger_flag.Replace, 
            custom_colour.NoChange, 
            0, "",  -- wildcard number, sound file name
            "wait_trigger_resume")
  assert (status == error_code.eOK, error_desc [status])
  wait_table [id] = thread
  return coroutine.yield ()  -- return line, wildcards
end -- function waitforregexp 

-- we call this to wait for a trigger (not a regexp)
function waitfor (thread, match)
  return waitforregexp (thread, MakeRegularExpression (match))
end -- function waitfor 

function function_call ()
  print "in function_call "
end --

--[[

GetStyle:
  Finds a style run corresponding to a given column 

  Returns nil if style run not found (eg. column out of range)

  If style run found returns: 
     * the style table (see below)
     * the character at that column
     * the style run number (eg. style 3)

The style table should contain the following:

  t.text        --> text of that (entire) style run
  t.length      --> length of the (entire) style run
  t.textcolour  --> text colour (RGB number)
  t.backcolour  --> background colour (RGB number)
  t.style       --> style bits (1=bold, 2=underline, 4=italic)

--]]

function GetStyle (styleRuns, wantedColumn)
local currentColumn = 1

   -- check arguments
   assert (type (styleRuns) == "table", 
           "First argument to GetStyle must be table of style runs")

   assert (type (wantedColumn) == "number" and wantedColumn >= 1, 
           "Second argument to GetStyle must be column number to find")

   -- go through each style
   for item, style in ipairs (styleRuns) do
     local position = wantedColumn - currentColumn + 1  -- where letter is in style
     currentColumn = currentColumn + style.length       -- next style starts here
     if currentColumn > wantedColumn then  -- if we are within this style
        return style, string.sub (style.text, position, position), item  -- done
     end -- if found column
   end -- for each style

   -- if not found: result is nil

end -- function GetStyle 

function my_trigger (name, line, wildcards, styles)
  col = string.find (line, "bleeding")
  if not col then
    return
  end -- word not found

  style = GetStyle (styles, col)

  print ("word is in", RGBColourToName (style.textcolour))
 
end -- function my_trigger


Note "script file processed"

