// EasterEggDlg.cpp : implementation file
//

#include "stdafx.h"
#include "mushclient.h"
#include "EasterEggDlg.h"

#ifdef _DEBUG
//#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CEasterEggDlg dialog


CEasterEggDlg::CEasterEggDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CEasterEggDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CEasterEggDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}


void CEasterEggDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CEasterEggDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CEasterEggDlg, CDialog)
	//{{AFX_MSG_MAP(CEasterEggDlg)
	ON_WM_PAINT()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CEasterEggDlg message handlers

BOOL CEasterEggDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
  //m_picHolder.CreateFromBitmap (IDB_NICK);

	
  CreatePalette ();

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}


void CEasterEggDlg::CreatePalette (void)
  {
   LPCTSTR lpszResourceName = (LPCTSTR) IDB_NICK;

   HBITMAP hBmp = (HBITMAP)::LoadImage( AfxGetResourceHandle(), 
                   lpszResourceName, IMAGE_BITMAP, 0,0, LR_CREATEDIBSECTION );

   if( hBmp == NULL ) 
           return;

   m_bitmap.Attach( hBmp );

   // Create a logical palette for the bitmap
   DIBSECTION ds;
   BITMAPINFOHEADER &bmInfo = ds.dsBmih;
   m_bitmap.GetObject( sizeof(ds), &ds );

   int nColors = bmInfo.biClrUsed ? bmInfo.biClrUsed : 1 << bmInfo.biBitCount;

   CClientDC dc(NULL);                     // Desktop DC

   if( nColors > 256 )
     return;

   // Create the palette

   RGBQUAD *pRGB = new RGBQUAD[nColors];
   CDC memDC;
   memDC.CreateCompatibleDC(&dc);

   memDC.SelectObject( &m_bitmap );
   ::GetDIBColorTable( memDC, 0, nColors, pRGB );

   UINT nSize = sizeof(LOGPALETTE) + (sizeof(PALETTEENTRY) * nColors);
   LOGPALETTE *pLP = (LOGPALETTE *) new BYTE[nSize];

   pLP->palVersion = 0x300;
   pLP->palNumEntries = nColors;

   for( int i=0; i < nColors; i++)
     {
     pLP->palPalEntry[i].peRed = pRGB[i].rgbRed;
     pLP->palPalEntry[i].peGreen = pRGB[i].rgbGreen;
     pLP->palPalEntry[i].peBlue = pRGB[i].rgbBlue;
     pLP->palPalEntry[i].peFlags = 0;
     }

   m_pal.CreatePalette( pLP );

   delete[] pLP;
   delete[] pRGB;


  }

void CEasterEggDlg::OnPaint() 
{
	CPaintDC dc(this); // device context for painting
	
   // Create a memory DC compatible with the paint DC
   CDC memDC;
   memDC.CreateCompatibleDC( &dc );

   CBitmap bitmap;
   CPalette palette;

//   GetBitmapAndPalette( IDB_BITMAP, bitmap, palette );
   CBitmap* pOldBitmap = memDC.SelectObject( &m_bitmap );

   // Select and realize the palette
   if( dc.GetDeviceCaps(RASTERCAPS) & RC_PALETTE && m_pal.m_hObject != NULL )
   {
           dc.SelectPalette( &m_pal, FALSE );
           dc.RealizePalette();
   }
   dc.BitBlt(0, 0, 180, 180, &memDC, 0, 0,SRCCOPY);
 	memDC.SelectObject(pOldBitmap);

}
