// testrslt.cpp : implementation file
//

#include "stdafx.h"
#include "mushclient.h"
#include "doc.h"
#include "ButtonColour.h"
#include "testrslt.h"

#ifdef _DEBUG
//#define new DEBUG_NEW
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CTestResultDialog dialog


CTestResultDialog::CTestResultDialog(CWnd* pParent /*=NULL*/)
	: CDialog(CTestResultDialog::IDD, pParent)
{
	//{{AFX_DATA_INIT(CTestResultDialog)
	m_test_result = _T("");
	m_bOmitFromLogFile = FALSE;
	m_bOmitFromOutput = FALSE;
	m_nColour = -1;
	//}}AFX_DATA_INIT

  m_bAlias = FALSE;

// default to black on white in case they never set them
  for (int i = 0; i < MAX_CUSTOM; i++)
    {
    m_customtext [i] = RGB (0, 0, 0);;
    m_customback [i] = RGB (255, 255, 255);;
    }

}


void CTestResultDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTestResultDialog)
	DDX_Control(pDX, IDC_TRIGGER_COLOUR, m_ctlColourComboBox);
	DDX_Control(pDX, IDC_TRIGGER_SWATCH2, m_ctlTriggerSwatch2);
	DDX_Control(pDX, IDC_COLOUR_LABEL, m_ctlColourLabel);
	DDX_Control(pDX, IDC_OMIT_FROM_OUTPUT, m_ctlOmitFromOutput);
	DDX_Control(pDX, IDC_OMIT_FROM_LOG, m_ctlOmitFromLogFile);
	DDX_Control(pDX, IDC_TRIGGER_SWATCH, m_ctlTriggerSwatch);
	DDX_Text(pDX, IDC_TEST_RESULT, m_test_result);
	DDX_Check(pDX, IDC_OMIT_FROM_LOG, m_bOmitFromLogFile);
	DDX_Check(pDX, IDC_OMIT_FROM_OUTPUT, m_bOmitFromOutput);
	DDX_CBIndex(pDX, IDC_TRIGGER_COLOUR, m_nColour);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CTestResultDialog, CDialog)
	//{{AFX_MSG_MAP(CTestResultDialog)
	ON_BN_CLICKED(IDC_HELPBUTTON, OnHelpbutton)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CTestResultDialog message handlers

void CTestResultDialog::OnHelpbutton() 
{
//  OnCmdMsg(ID_HELP, CN_COMMAND, NULL, NULL);
	App.WinHelp(m_nIDHelp + HID_BASE_RESOURCE);
}

BOOL CTestResultDialog::OnInitDialog() 
{
	CDialog::OnInitDialog();

  
  if (m_bAlias)
    {
    m_ctlColourComboBox.ShowWindow (SW_HIDE);    
    m_ctlColourLabel.ShowWindow (SW_HIDE);    
    m_ctlOmitFromOutput.ShowWindow (SW_HIDE);    
    m_ctlOmitFromLogFile.ShowWindow (SW_HIDE); 
    m_ctlTriggerSwatch.ShowWindow (SW_HIDE);    
    m_ctlTriggerSwatch2.ShowWindow (SW_HIDE);    
    }   // end of being an alias output
  else
    {
    FixSwatch (m_ctlTriggerSwatch, m_ctlTriggerSwatch2, m_nColour);

    for (int i = 0; i < MAX_CUSTOM; i++)
      {
      m_ctlColourComboBox.m_customtext [i] = m_customtext [i];
      m_ctlColourComboBox.m_customback [i] = m_customback [i];
      }

    // load combo box now
    m_ctlColourComboBox.ResetContent ();
    m_ctlColourComboBox.AddString ("(no change)");
    for (i = 0; i < MAX_CUSTOM; i++)
      m_ctlColourComboBox.AddString (m_strCustomName [i]);

    // put the selection back
    m_ctlColourComboBox.SetCurSel (m_nColour);

    } // not being an alias

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}


void CTestResultDialog::FixSwatch (CColourButton & m_ctlSwatch, 
                             CColourButton & m_ctlSwatch2,
                             int iNewColour)
  {
  if (iNewColour == 0)
    {
     m_ctlSwatch.ShowWindow (SW_HIDE);
     m_ctlSwatch2.ShowWindow (SW_HIDE);
    }
  else
    {
    m_ctlSwatch.ShowWindow (SW_SHOW | SW_SHOWNOACTIVATE);
    m_ctlSwatch2.ShowWindow (SW_SHOW | SW_SHOWNOACTIVATE);
    m_ctlSwatch.m_colour = m_customtext [iNewColour - 1];
    m_ctlSwatch2.m_colour = m_customback [iNewColour - 1];
    m_ctlSwatch.RedrawWindow ();
    m_ctlSwatch2.RedrawWindow ();
    }
  } // end of FixSwatch
