; -------- MUSHclient install script
; For use with NSIS installer (see www.nullsort.com)

;
;  get a local copy of the .exe and compress it
;

!system "copy ..\WinRel\mushclient.exe mushclient.exe" = 0
!system "upx mushclient.exe" = 0

; The name of the installer
Name "MUSHclient"
Caption "MUSHclient Installer"
; BGGradient FE8100 FCFC04  771F0E 
; InstallColors FF8080 000030


; The file to write
OutFile mushclient40x.exe

; The default installation directory
InstallDir $PROGRAMFILES\MUSHclient

; Registry key to check for directory (so if you install again, it will 
; overwrite the old one automatically)
InstallDirRegKey HKCU "SOFTWARE\Gammon Software Solutions\MUSHclient\General Options" "InstallDir"

; The text to prompt the user to enter a directory
ComponentText "This will install MUSHclient on your computer. Select which optional components that you want installed."

; The text to prompt the user to enter a directory
DirText "Setup has determined the optimal location to install. If you would like to change the directory, do so now."

; options

CRCCheck on
ShowInstDetails show
SetOverwrite on
;SetOverwrite ifnewer
SetCompress auto
SetCompressor lzma
SetDateSave on

; license

LicenseText "Please read the following agreement and click on 'Next' if you agree to it:"
LicenseData agreement.txt

; install types

InstType Typical  ; 1
InstType Full     ; 2
InstType Compact  ; 3
CheckBitmap  "${NSISDIR}\Contrib\Graphics\Checks\simple-round2.bmp" 

Function .onInit

; splash screen

# the plugins dir is automatically deleted when the installer exits
;     InitPluginsDir
;
;    File /oname=$PLUGINSDIR\splash.bmp "MUSHclient Installer.bmp"
;    splash::show 3000 $PLUGINSDIR\splash
; 
; Pop $0 

FunctionEnd


; The stuff to install
Section "-MUSHclient program (required)"
  ; Set output path to the installation directory.
  SetOutPath $INSTDIR

  ; Which section type it is in
  SectionIn 1 2 3  ; typical, full, compact

    WriteUninstaller "uninstall.exe"

  ; Put files there

  File "Readme.txt" ; in install directory

  File "mushclient.exe"
  File "..\WinRel\lua5.1.dll"
  File "..\..\lua51_dll\Release\lua5.1.lib"
  File "..\mushclient.HLP"
  File "..\mushclient.cnt"
  File "..\install\mushclient.ico"
  File "..\tips.txt"
  File "..\Example_Filters.lua"
  File "..\names.txt"
  File /oname="license.txt" "agreement.txt"

  ; Write the installation path into the registry
  WriteRegStr HKCU "Software\Gammon Software Solutions\MUSHclient\General Options" "InstallDir" $INSTDIR

  ; Write the uninstall keys for Windows
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\MUSHclient" "DisplayName" "MUSHclient (remove only)"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\MUSHclient" "UninstallString" "$INSTDIR\uninstall.exe"

  ; directory for world files (worlds subdirectory)

    ReadRegStr $1 HKCU "Software\Gammon Software Solutions\MUSHclient\Global prefs" "DefaultWorldFileDirectory"

    ; no existing directory - create one
    StrCmp $1 "" 0 NoCreateWorldDirectory
    WriteRegStr HKCU "Software\Gammon Software Solutions\MUSHclient\Global prefs" "DefaultWorldFileDirectory" "$INSTDIR\worlds\"
    CreateDirectory "$INSTDIR\worlds"

    ; not needed
    NoCreateWorldDirectory:

  
  ; directory for plugin files (worlds\plugins subdirectory)

    ReadRegStr $1 HKCU "Software\Gammon Software Solutions\MUSHclient\Global prefs" "PluginsDirectory"

    ; no existing directory - create one
    StrCmp $1 "" 0 NoCreatePluginsDirectory
    WriteRegStr HKCU "Software\Gammon Software Solutions\MUSHclient\Global prefs" "PluginsDirectory" "$INSTDIR\worlds\plugins\"
    CreateDirectory "$INSTDIR\worlds\plugins"
    CreateDirectory "$INSTDIR\worlds\plugins\state"

    ; not needed
    NoCreatePluginsDirectory:
      
  ; directory for log files (logs subdirectory)

    ReadRegStr $1 HKCU "Software\Gammon Software Solutions\MUSHclient\Global prefs" "DefaultLogFileDirectory"

    ; no existing directory - create one
    StrCmp $1 "" 0 NoCreateLogDirectory
    WriteRegStr HKCU "Software\Gammon Software Solutions\MUSHclient\Global prefs" "DefaultLogFileDirectory" "$INSTDIR\logs\"
    CreateDirectory "$INSTDIR\logs"

    ; not needed
    NoCreateLogDirectory:

SectionEnd

Section "Spell checker"
  ; Which section type it is in
  SectionIn 1 2   ; typical, full

  ; Set output path to the spell directory.
  SetOutPath $INSTDIR\spell

  ; Put files there

  File "..\spell\english-words.10"
  File "..\spell\english-words.20"
  File "..\spell\english-words.35"
  File "..\spell\english-words.40"
  File "..\spell\english-upper.10"
  File "..\spell\english-upper.35"
  File "..\spell\english-upper.40"
  File "..\spell\american-words.10"
  File "..\spell\american-words.20"
  File "..\spell\english-contractions.10"
  File "..\spell\english-contractions.35"
 

  ; Set output path to the installation directory.
  SetOutPath $INSTDIR

  ; New spell checker
  File "..\spellchecker.lua"

SectionEnd

Section "Documentation"
  ; Which section type it is in
  SectionIn 1 2   ; typical, full

  ; Set output path to the doc directory.
  SetOutPath $INSTDIR\docs

  ; Put files there
  File "..\docs\RegularExpressions.txt"
  File "..\docs\mersenne_twister.txt"
  File "..\docs\lua_license.txt"
SectionEnd

Section "Fonts"

  ; Which section type it is in
  SectionIn 1 2   ; typical, full

  ; Set output path to the fonts directory.
  SetOutPath $INSTDIR\fonts

  ; Put files there
  File "..\fonts\banner.flf"
  File "..\fonts\big.flf"
  File "..\fonts\block.flf"
  File "..\fonts\bubble.flf"
  File "..\fonts\digital.flf"
  File "..\fonts\lean.flf"
  File "..\fonts\mini.flf"
  File "..\fonts\script.flf"
  File "..\fonts\shadow.flf"
  File "..\fonts\slant.flf"
  File "..\fonts\small.flf"
  File "..\fonts\smscript.flf"
  File "..\fonts\smshadow.flf"
  File "..\fonts\smslant.flf"
  File "..\fonts\standard.flf"
  File "..\fonts\term.flf"
SectionEnd

Section "Scripting"
  ; Which section type it is in
  SectionIn 1 2   ; typical, full

  ;
  ;  directory for scripts
  ;
  CreateDirectory "$INSTDIR\scripts"

  ;
  ;  directory for Lua scripts
  ;
  CreateDirectory "$INSTDIR\lua"
    
  ; Set output path to the lua subdirectory.
  SetOutPath $INSTDIR\lua

SetOverwrite ifnewer
   File "..\lua\addxml.lua"
   File "..\lua\check.lua"
   File "..\lua\declare.lua"
   File "..\lua\getlines.lua"
   File "..\lua\pairsbykeys.lua"
   File "..\lua\serialize.lua"
   File "..\lua\tprint.lua"
   File "..\lua\var.lua"
   File "..\lua\wait.lua"

  ; Set output path to the scripts subdirectory.
  SetOutPath $INSTDIR\scripts

  ; Put files there
SetOverwrite ifnewer
  File "..\exampscript.vbs"
  File "..\exampscript.js"
  File "..\exampscript.pl"
  File "..\exampscript.pys"
  File "..\exampscript.lua"
SetOverwrite on
  File "..\WinRel\MUSHclient.tlb"
SectionEnd

Section "Plugins"
  ; Which section type it is in
  SectionIn 1 2   ; typical, full

    ReadRegStr $1 HKCU "Software\Gammon Software Solutions\MUSHclient\Global prefs" "PluginsDirectory"

  ; Set output path to the installation subdirectory.
  SetOutPath $1

  ; Put files there
  File "..\plugins\constants.vbs"
  File "..\plugins\constants.js"
  File "..\plugins\constants.pl"
  File "..\plugins\constants.pys"
  File "..\plugins\constants.lua"
  File "..\plugins\plugin_list.xml"
  File "..\plugins\plugin_summary.xml"
  File "..\plugins\random_socials.xml"
  File "..\plugins\sample_plugin.xml"
  File "..\plugins\scan.xml"
  File "..\plugins\msp.xml"
  File "..\plugins\reverse_speedwalk.xml"
  File "..\plugins\SMAUG_automapper_helper.xml"
  File "..\plugins\multiple_send.xml"
  File "..\plugins\idle_message.xml"
  File "..\plugins\MUSH_teleport.xml"
  File "..\plugins\ColourNote.xml"
  File "..\plugins\NewActivity.xml"
  File "..\plugins\MudDatabase.xml"
  File "..\plugins\Chat.xml"
  File "..\plugins\Health_Bar.xml"
  File "..\plugins\JScript_Version.xml"
  File "..\plugins\Perlscript_Version.xml"
  File "..\plugins\Python_Version.xml"
  File "..\plugins\VBscript_Version.xml"
  File "..\plugins\ANSI_Log.xml"
  File "..\plugins\Hyperlink_URL.xml"
  File "..\plugins\Gag.xml"
  File "..\plugins\Status_Bar_Prompt.xml"
  File "..\plugins\Timer.xml"
  File "..\plugins\ShowActivity.xml"
  File "..\plugins\Installer_sumcheck.xml"

SectionEnd


; optional section
Section "Start Menu Shortcuts"
  ; Which section type it is in
  SectionIn 1 2   ; typical, full

  SetOutPath "$SMPROGRAMS\MUSHclient"
  CreateShortCut "$SMPROGRAMS\MUSHclient\MUSHclient.lnk" "$INSTDIR\MUSHclient.exe" "" "$INSTDIR\MUSHclient.exe" 0
  CreateShortCut "$SMPROGRAMS\MUSHclient\Read Me.lnk" "$INSTDIR\Readme.txt" "" "$INSTDIR\Readme.txt" 0
  CreateShortCut "$SMPROGRAMS\MUSHclient\Uninstall MUSHclient.lnk" "$INSTDIR\uninstall.exe" "" "$INSTDIR\uninstall.exe" 0
SectionEnd

; uninstall stuff
UninstallText "Are you sure you want to remove MUSHclient and all of its components?"

; special uninstall section.
Section Uninstall

  ; remove registry keys
  DeleteRegKey HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\MUSHclient"
  DeleteRegKey HKCU "Software\Gammon Software Solutions\MUSHclient"

  ; remove files

  ; program
  Delete "$INSTDIR\MUSHclient.exe"
  Delete "$INSTDIR\lua5.1.dll"
  Delete "$INSTDIR\lua5.1.lib"
  Delete "$INSTDIR\MUSHclient.ico"
  Delete "$INSTDIR\MUSHclient.hlp"
  Delete "$INSTDIR\MUSHclient.cnt"

  ; readme and tips
  Delete "$INSTDIR\readme.txt"
  Delete "$INSTDIR\tips.txt"
  
  ; example trigger/alias/timer list filters
  Delete "$INSTDIR\Example_Filters.lua"

  ; and character name generation file
  Delete "$INSTDIR\names.txt"

  ; scripting stuff
  Delete "$INSTDIR\scripts\MUSHclient.tlb"
  Delete "$INSTDIR\scripts\exampscript.vbs"
  Delete "$INSTDIR\scripts\exampscript.js"
  Delete "$INSTDIR\scripts\exampscript.pl"
  Delete "$INSTDIR\scripts\exampscript.pys"
  Delete "$INSTDIR\scripts\exampscript.lua"

  ; lua stuff
  Delete "$INSTDIR\lua\addxml.lua"
  Delete "$INSTDIR\lua\check.lua"
  Delete "$INSTDIR\lua\declare.lua"
  Delete "$INSTDIR\lua\getlines.lua"
  Delete "$INSTDIR\lua\pairsbykeys.lua"
  Delete "$INSTDIR\lua\serialize.lua"
  Delete "$INSTDIR\lua\tprint.lua"
  Delete "$INSTDIR\lua\var.lua"
  Delete "$INSTDIR\lua\wait.lua"
  
  ; spell checker stuff
  Delete "$INSTDIR\spellchecker.lua"
  Delete "$INSTDIR\spell\english-words.10"
  Delete "$INSTDIR\spell\english-words.20"
  Delete "$INSTDIR\spell\english-words.35"
  Delete "$INSTDIR\spell\english-words.40"
  Delete "$INSTDIR\spell\english-upper.10"
  Delete "$INSTDIR\spell\english-upper.35"
  Delete "$INSTDIR\spell\english-upper.40"
  Delete "$INSTDIR\spell\american-words.10"
  Delete "$INSTDIR\spell\american-words.20"
  Delete "$INSTDIR\spell\english-contractions.10"
  Delete "$INSTDIR\spell\english-contractions.35"
  
  RMDir  "$INSTDIR\spell"

  ; docs
  Delete "$INSTDIR\docs\RegularExpressions.txt"
  Delete "$INSTDIR\docs\mersenne_twister.txt"
  Delete "$INSTDIR\docs\lua_license.txt"
  RMDir  "$INSTDIR\docs"

  ; fonts
  Delete "$INSTDIR\fonts\*.flf"
  RMDir  "$INSTDIR\fonts"

  ; plugins
  Delete "$INSTDIR\plugins\constants.vbs"
  Delete "$INSTDIR\plugins\constants.js"
  Delete "$INSTDIR\plugins\constants.pl"
  Delete "$INSTDIR\plugins\constants.pys"
  Delete "$INSTDIR\plugins\constants.lua"
  Delete "$INSTDIR\plugins\plugin_list.xml"
  Delete "$INSTDIR\plugins\random_socials.xml"
  Delete "$INSTDIR\plugins\sample_plugin.xml"
  Delete "$INSTDIR\plugins\scan.xml"
  Delete "$INSTDIR\plugins\msp.xml"
  Delete "$INSTDIR\plugins\reverse_speedwalk.xml"
  Delete "$INSTDIR\plugins\SMAUG_automapper_helper.xml"
  Delete "$INSTDIR\plugins\multiple_send.xml"
  Delete "$INSTDIR\plugins\idle_message.xml"
  Delete "$INSTDIR\plugins\MUSH_teleport.xml"
  Delete "$INSTDIR\plugins\ColourNote.xml"
  Delete "$INSTDIR\plugins\NewActivity.xml"
  Delete "$INSTDIR\plugins\MudDatabase.xml"
  Delete "$INSTDIR\plugins\Chat.xml"
  Delete "$INSTDIR\plugins\Health_Bar.xml"
  Delete "$INSTDIR\plugins\JScript_Version.xml"
  Delete "$INSTDIR\plugins\Perlscript_Version.xml"
  Delete "$INSTDIR\plugins\Python_Version.xml"
  Delete "$INSTDIR\plugins\VBscript_Version.xml"
  Delete "$INSTDIR\plugins\ANSI_Log.xml"
  Delete "$INSTDIR\plugins\Hyperlink_URL.xml"
  Delete "$INSTDIR\plugins\Gag.xml"
  Delete "$INSTDIR\plugins\Status_Bar_Prompt.xml"
  Delete "$INSTDIR\plugins\Timer.xml"
  Delete "$INSTDIR\plugins\ShowActivity.xml"
  Delete "$INSTDIR\plugins\Installer_sumcheck.xml"

  ; MUST REMOVE UNINSTALLER, too
  Delete $INSTDIR\uninstall.exe

  ; remove shortcuts, if any.
  Delete "$SMPROGRAMS\MUSHclient\*.lnk"
  RMDir "$SMPROGRAMS\MUSHclient"

  ; delete worlds, lua and logs directory, if empty
  RMDir  "$INSTDIR\worlds"
  RMDir  "$INSTDIR\logs"
  RMDir  "$INSTDIR\lua"

  ; remove directories used.
  RMDir "$INSTDIR"

  ; warn user if not all files removed
  IfErrors CannotRemoveDirectory CanRemoveDirectory

  CannotRemoveDirectory:

  MessageBox MB_OK|MB_ICONEXCLAMATION  \
    "Some files or folders (probably that you created) could not be removed and should be deleted manually if desired."

  CanRemoveDirectory:

SectionEnd

; post-install

Function .onInstSuccess
  MessageBox MB_YESNO "Installation of MUSHclient is complete. View the readme file?" IDNO NoReadme
    Exec 'notepad "$INSTDIR\readme.txt"' 
  NoReadme:
FunctionEnd


